# settings page
# version 1.0
# Copyright NASA 2025 under MIT open source license
# Author Paul Mirel

import displayio
from adafruit_display_text import label
import vectorio
import terminalio
from .classm_page import Page

class Settings_Page( Page ):
    def __init__( self, instrument ):
        super().__init__()
        self.page_name = "Settings"
        self.instrument = instrument
        self.palette = instrument.palette
        self.selection = 0
        self.selection_count = 0
        self.last_selection = 0
        self.selection_color_index = 6
        self.field_selected_color_index = 5
        self.field_not_selected_color_index = 9
        self.field_selected = False
        self.intervals = [1,2,3,4,5,6,7,8,9,10,15,20,25,30,45,60,2*60,3*60,4*60,5*60,10*60,15*60,20*60,30*60,45*60,3600,2*3600,3*3600,4*3600,5*3600,10*3600]
        self.sample_interval_index = 1
        self.serial_interval_index = 1
    def make_group( self ):
        self.group = displayio.Group()
        background = vectorio.Rectangle(pixel_shader=self.palette, color_index=9, width=320, height=240, x=0, y=0)
        self.group.append( background )

        line_spacing = 30
        start_x = 1
        line_y = 2
        select_width = 4
        border_width = 2
        height_1 = 10
        offset_1 = 6
        height_2 = 32
        offset_2 = 9
        self.selection_rectangles = []
        self.value_areas = []
        self.text_areas = []

        line_values = ["System Settings:"]
        line_widths = [300]
        x = start_x
        for index in range(0, len(line_values)):
            text_group = displayio.Group(scale=2, x=x+offset_2, y=line_y+int(height_2/2))
            self.text_area = label.Label(terminalio.FONT, text=line_values[index], color=self.palette[0])
            text_group.append(self.text_area)
            self.text_areas.append(self.text_area)
            self.group.append(text_group)
            x += line_widths[index]

        line_y = line_y + line_spacing
        line_values = ["Sample interval:", " --"]
        line_selectable = [ False, True ]
        line_widths = [200,115]
        x = start_x
        for index in range(0, len(line_values)):
            if line_selectable[index]:
                selection_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=0, width=line_widths[index],
                                                                    height=height_2, x=x, y=line_y)
                selection_rectangle.hidden = False # True
                self.group.append(selection_rectangle)
                self.selection_rectangles.append(selection_rectangle)

                border_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=0, width=line_widths[index]-2*(select_width-border_width),
                                                                    height=height_2-2*(select_width-border_width), x=x+select_width-border_width, y=line_y+select_width-border_width)
                self.group.append(border_rectangle)

                self.area_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=9, width=line_widths[index]-2*select_width,
                                                            height=height_2-2*select_width, x=x+select_width, y=line_y+select_width)
                self.group.append(self.area_rectangle)
                self.value_areas.append(self.area_rectangle)

            text_group = displayio.Group(scale=2, x=x+offset_2, y=line_y+int(height_2/2))
            self.text_area = label.Label(terminalio.FONT, text=line_values[index], color=self.palette[0])
            self.text_areas.append(self.text_area)
            text_group.append(self.text_area)
            self.group.append(text_group)
            x += line_widths[index]

        line_y = line_y + line_spacing
        line_values = ["Burst count:", " --"]
        line_selectable = [False, True ]
        line_widths =[200,115]
        x = start_x
        for index in range(0, len(line_values)):
            if line_selectable[index]:
                selection_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=0, width=line_widths[index],
                                                                    height=height_2, x=x, y=line_y)
                selection_rectangle.hidden = True
                self.group.append(selection_rectangle)
                self.selection_rectangles.append(selection_rectangle)

                border_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=0, width=line_widths[index]-2*(select_width-border_width),
                                                                    height=height_2-2*(select_width-border_width), x=x+select_width-border_width, y=line_y+select_width-border_width)
                self.group.append(border_rectangle)

                self.area_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=9, width=line_widths[index]-2*select_width,
                                                            height=height_2-2*select_width, x=x+select_width, y=line_y+select_width)
                self.group.append(self.area_rectangle)
                self.value_areas.append(self.area_rectangle)

            text_group = displayio.Group(scale=2, x=x+offset_2, y=line_y+int(height_2/2))
            self.text_area = label.Label(terminalio.FONT, text=line_values[index], color=self.palette[0])
            self.text_areas.append(self.text_area)
            text_group.append(self.text_area)
            self.group.append(text_group)
            x += line_widths[index]

        line_y = line_y + line_spacing
        line_values = ["Serial output:", " -- "]
        line_selectable = [False, True ]
        line_widths = [200,115]
        x = start_x
        for index in range(0, len(line_values)):
            if line_selectable[index]:
                selection_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=0, width=line_widths[index],
                                                                    height=height_2, x=x, y=line_y)
                selection_rectangle.hidden = True
                self.group.append(selection_rectangle)
                self.selection_rectangles.append(selection_rectangle)

                border_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=0, width=line_widths[index]-2*(select_width-border_width),
                                                                    height=height_2-2*(select_width-border_width), x=x+select_width-border_width, y=line_y+select_width-border_width)
                self.group.append(border_rectangle)

                self.area_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=9, width=line_widths[index]-2*select_width,
                                                            height=height_2-2*select_width, x=x+select_width, y=line_y+select_width)
                self.group.append(self.area_rectangle)
                self.value_areas.append(self.area_rectangle)

            text_group = displayio.Group(scale=2, x=x+offset_2, y=line_y+int(height_2/2))
            self.text_area = label.Label(terminalio.FONT, text=line_values[index], color=self.palette[0])
            self.text_areas.append(self.text_area)
            text_group.append(self.text_area)
            self.group.append(text_group)
            x += line_widths[index]

        line_y = line_y + line_spacing
        line_values = ["Serial interval:", " --"]
        line_selectable = [False, True ]
        line_widths = [200,115]
        x = start_x
        for index in range(0, len(line_values)):
            if line_selectable[index]:
                selection_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=0, width=line_widths[index],
                                                                    height=height_2, x=x, y=line_y)
                selection_rectangle.hidden = True
                self.group.append(selection_rectangle)
                self.selection_rectangles.append(selection_rectangle)

                border_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=0, width=line_widths[index]-2*(select_width-border_width),
                                                                    height=height_2-2*(select_width-border_width), x=x+select_width-border_width, y=line_y+select_width-border_width)
                self.group.append(border_rectangle)

                self.area_rectangle = vectorio.Rectangle(pixel_shader=self.palette, color_index=9, width=line_widths[index]-2*select_width,
                                                            height=height_2-2*select_width, x=x+select_width, y=line_y+select_width)
                self.group.append(self.area_rectangle)
                self.value_areas.append(self.area_rectangle)

            text_group = displayio.Group(scale=2, x=x+offset_2, y=line_y+int(height_2/2))
            self.text_area = label.Label(terminalio.FONT, text=line_values[index], color=self.palette[0])
            self.text_areas.append(self.text_area)
            text_group.append(self.text_area)
            self.group.append(text_group)
            x += line_widths[index]

        line_y = line_y + line_spacing+14
        line_values = ["Set default values in the user_settings.py file"]
        line_selectable = [False ]
        line_widths = [320]
        x = start_x +10
        for index in range(0, len(line_values)):
            text_group = displayio.Group(scale=1, x=x+offset_1, y=line_y+int(height_1/2))
            self.text_area = label.Label(terminalio.FONT, text=line_values[index], color=self.palette[0])
            self.text_areas.append(self.text_area)
            text_group.append(self.text_area)
            self.group.append(text_group)
            x += line_widths[index]

        line_y = line_y + height_1+2
        line_values = ["in the CIRCUITPY/configuration_files/ folder"]
        line_selectable = [False ]
        line_widths = [320]
        x = start_x +10
        for index in range(0, len(line_values)):
            text_group = displayio.Group(scale=1, x=x+offset_1, y=line_y+int(height_1/2))
            self.text_area = label.Label(terminalio.FONT, text=line_values[index], color=self.palette[0])
            self.text_areas.append(self.text_area)
            text_group.append(self.text_area)
            self.group.append(text_group)
            x += line_widths[index]

        # RETURN
        select_width = 4
        return_height = 28
        return_select_y = 240 - 4 - 2 - return_height - select_width
        return_select_height = return_height + 2*select_width
        return_y = return_select_y + select_width
        return_text_y = return_y + 12
        return_select_width = 100
        return_select_x = 320 - 4 - return_select_width
        return_x = return_select_x + select_width
        self.return_select = vectorio.Rectangle(pixel_shader=self.palette, color_index=0, width=return_select_width, height=return_select_height, x=return_select_x, y=return_select_y)
        self.group.append( self.return_select )
        self.selection_rectangles.append(self.return_select)
        self.selection_count += 1
        self.return_select.hidden = True
        return_control_width = return_select_width - 2 * select_width
        self.return_color = vectorio.Rectangle(pixel_shader=self.palette, color_index=19, width=return_control_width, height=return_height, x=return_x, y=return_y)
        self.group.append( self.return_color )
        return_text_x = return_x + 10
        return_group = displayio.Group(scale=2, x=return_text_x, y=return_text_y)
        return_text = "RETURN"
        self.return_text_area = label.Label(terminalio.FONT, text=return_text, color=self.palette[0])
        return_group.append(self.return_text_area)
        self.group.append(return_group)

        self.selection_count = len( self.selection_rectangles )
        return self.group

    def action( self ):
        if self.instrument.encoder_increment != 0:
            if self.field_selected:
                if self.selection == 0:
                    self.sample_interval_index += self.instrument.encoder_increment
                    if self.sample_interval_index < 0:
                        self.sample_interval_index = 0
                    if self.sample_interval_index > len(self.intervals) -1:
                        self.sample_interval_index = len(self.intervals) -1
                    self.instrument.sample_interval_s = self.intervals[self.sample_interval_index]
                if self.selection == 1:
                    set_burst_count = self.instrument.burst_count + self.instrument.encoder_increment
                    if set_burst_count < 1:
                        set_burst_count = 1
                    if set_burst_count > 20:
                        set_burst_count = 20
                    self.instrument.burst_count = set_burst_count
                if self.selection == 2:
                    self.instrument.serial_out = not self.instrument.serial_out
                if self.selection == 3:
                    self.serial_interval_index += self.instrument.encoder_increment
                    if self.serial_interval_index < 0:
                        self.serial_interval_index = 0
                    if self.serial_interval_index > len(self.intervals) -1:
                        self.serial_interval_index = len(self.intervals) -1
                    self.instrument.serial_interval_s = self.intervals[self.serial_interval_index]
                if self.selection == 4:
                    self.instrument.active_page_number = self.instrument.pages_dict["Main"]
            self.instrument.encoder_increment = 0
            self.update_values()

        if self.instrument.button_pressed:
            if self.selection == 4:
                self.instrument.active_page_number = self.instrument.pages_dict["Main"]
            else:
                self.field_selected = not self.field_selected
                if self.selection == 0:
                    if self.field_selected:
                        self.value_areas[0].color_index = self.field_selected_color_index
                    else:
                        self.value_areas[0].color_index = self.field_not_selected_color_index
                if self.selection == 1:
                    if self.field_selected:
                        self.value_areas[1].color_index = self.field_selected_color_index
                    else:
                        self.value_areas[1].color_index = self.field_not_selected_color_index
                if self.selection == 2:
                    if self.field_selected:
                        self.value_areas[2].color_index = self.field_selected_color_index
                    else:
                        self.value_areas[2].color_index = self.field_not_selected_color_index
                if self.selection == 3:
                    if self.field_selected:
                        self.value_areas[3].color_index = self.field_selected_color_index
                    else:
                        self.value_areas[3].color_index = self.field_not_selected_color_index

            self.instrument.button_pressed = False
            self.update_values()

    def update_values( self ):
        self.text_areas[2].text = self.interval_units( self.instrument.sample_interval_s )
        self.text_areas[4].text = "{}".format(self.instrument.burst_count)
        if self.instrument.serial_out:
            self.text_areas[6].text = "enabled"
        else:
            self.text_areas[6].text = "disabled"
        self.text_areas[8].text = self.interval_units( self.instrument.serial_interval_s )

    def update_selection(self):
        self.selection_rectangles[self.last_selection].hidden = True
        self.selection_rectangles[self.selection].hidden = False

    def hide_all_selections( self ):
        for item in self.selection_rectangles:
            if item.hidden == False:
                item.hidden = True


    def interval_units( self, intervals ):
        intervalm = intervals / 60
        intervalh = intervalm / 60
        intervald = intervalh / 24
        if intervals < 60:
            interval_text = "{}s".format(int(intervals))
        elif intervalm < 60:
            interval_text = "{}m".format(int(intervalm))
        elif intervalh < 24:
            interval_text = "{}h".format(int(intervalh))
        else:
            interval_text = "{}d".format(int(intervald))
        return interval_text

def make_settings_page( instrument ):
    instrument.welcome_page.announce( "make_settings_page" )
    page = Settings_Page( instrument )
    group = page.make_group()
    page.hide()
    instrument.main_display_group.append( group )
    instrument.pages_list.append( page )
    return page
