# mlx90614 module
# Copyright NASA 2025 under MIT open source license
# Author Paul Mirel

import adafruit_mlx90614
from .classm_device import Device


def initialize_mlx90614_surface_thermometer( instrument ):
    mlx90614_surface_thermometer = Null_mlx90614_Surface_Thermometer()
    try:
        mlx90614_surface_thermometer = mlx90614_Surface_Thermometer( instrument.i2c_bus )
        instrument.welcome_page.announce( "initialize_mlx90614_surface_thermometer" )
        instrument.sensors_present.append( mlx90614_surface_thermometer )
    except:
        pass
    return mlx90614_surface_thermometer

class mlx90614_Surface_Thermometer( Device ):
    def __init__( self, com_bus ):
        super().__init__(name = "surface_therm", pn = "mlx90614", address = 0x5A, swob = adafruit_mlx90614.MLX90614( com_bus ))
        self.surface_temperature_C = 0
        self.ambient_temperature_C = 0
        self.parameters = [ "T_surface_C","T_ambient_C" ]
        self.values = [0,0]
    def read(self):
        self.surface_temperature_C = self.swob.object_temperature
        self.ambient_temperature_C = self.swob.ambient_temperature
        self.values = [round(self.surface_temperature_C,1),round(self.ambient_temperature_C,1)]
    def log(self):
        log = "{}, {}".format( self.name, self.pn )
        for index in range (0, len(self.parameters)):
            log = log + ", {}, {}".format( self.parameters[index], self.values[index])
        return log

    def printlog(self):
        print( self.log())

    def get_values( self ):
        return( self.values )

class Null_mlx90614_Surface_Thermometer(Device):
    def __init__( self ):
        super().__init__(name = None, swob = None)
        self.surface_temperature_C = 0
        self.ambient_temperature_C = 0
    def read(self):
        pass
    def log(self):
        pass
    def report(self):
        pass
    def printlog(self):
        pass
    def header(self):
        pass
